function plot_building(data,planta)

%{

 This function makes a plot of all the building with all the diferent
 elements. The arguments of this function are:
   
    data -> Object with all the model information
    planta -> An integer showing the floor that must be plot
       -1  -> All the building
        0  -> Planta baja
        1  -> First Floor
        2  -> Second Floor

 Fernando Jess Aranda Polo 
 Last change:
 1/03/2020

%}


if (planta == -1)
    
    axis([-5 70 -5 30 -10 12])
    
    % Pintdata.aMos los muros esteriores
    X1 = [];
    X2 = [];
    Y1 = [];
    Y2 = [];
    Z1 = [];
    Z2 = [];


    for j=1:1:data.finPlantaBaja 
        % Lnea 1 (abajo)
        X1 = [X1 data.wall(j).p1(1)];
        X2 = [X2 data.wall(j).p2(1)];
        Y1 = [Y1 data.wall(j).p1(2)];
        Y2 = [Y2 data.wall(j).p2(2)];
        Z1 = [Z1 data.wall(j).p1(3)];
        Z2 = [Z2 data.wall(j).p2(3)];

        % Lnea 1 (haca arriba)
        X1 = [X1 data.wall(j).p2(1)];
        X2 = [X2 data.wall(j).p3(1)];
        Y1 = [Y1 data.wall(j).p2(2)];
        Y2 = [Y2 data.wall(j).p3(2)];
        Z1 = [Z1 data.wall(j).p2(3)];
        Z2 = [Z2 data.wall(j).p3(3)];

        % Lnea 1 (arriba)
        X1 = [X1 data.wall(j).p3(1)];
        X2 = [X2 data.wall(j).p4(1)];
        Y1 = [Y1 data.wall(j).p3(2)];
        Y2 = [Y2 data.wall(j).p4(2)];
        Z1 = [Z1 data.wall(j).p3(3)];
        Z2 = [Z2 data.wall(j).p4(3)];


        % Lnea 1 (haca abajo)
        X1 = [X1 data.wall(j).p4(1)];
        X2 = [X2 data.wall(j).p1(1)];
        Y1 = [Y1 data.wall(j).p4(2)];
        Y2 = [Y2 data.wall(j).p1(2)];
        Z1 = [Z1 data.wall(j).p4(3)];
        Z2 = [Z2 data.wall(j).p1(3)];    
    end

    % Muros del sistema
        % Para ver si est todo correcto
        
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'color','b','MarkerSize',10);
        hold on


    X1 = [];
    X2 = [];
    Y1 = [];
    Y2 = [];
    Z1 = [];
    Z2 = [];

    for j=data.finPlantaBaja+1:1:data.finPrimeraPlanta 
        % Lnea 1 (abajo)
        X1 = [X1 data.wall(j).p1(1)];
        X2 = [X2 data.wall(j).p2(1)];
        Y1 = [Y1 data.wall(j).p1(2)];
        Y2 = [Y2 data.wall(j).p2(2)];
        Z1 = [Z1 data.wall(j).p1(3)];
        Z2 = [Z2 data.wall(j).p2(3)];

        % Lnea 1 (haca arriba)
        X1 = [X1 data.wall(j).p2(1)];
        X2 = [X2 data.wall(j).p3(1)];
        Y1 = [Y1 data.wall(j).p2(2)];
        Y2 = [Y2 data.wall(j).p3(2)];
        Z1 = [Z1 data.wall(j).p2(3)];
        Z2 = [Z2 data.wall(j).p3(3)];

        % Lnea 1 (arriba)
        X1 = [X1 data.wall(j).p3(1)];
        X2 = [X2 data.wall(j).p4(1)];
        Y1 = [Y1 data.wall(j).p3(2)];
        Y2 = [Y2 data.wall(j).p4(2)];
        Z1 = [Z1 data.wall(j).p3(3)];
        Z2 = [Z2 data.wall(j).p4(3)];


        % Lnea 1 (haca abajo)
        X1 = [X1 data.wall(j).p4(1)];
        X2 = [X2 data.wall(j).p1(1)];
        Y1 = [Y1 data.wall(j).p4(2)];
        Y2 = [Y2 data.wall(j).p1(2)];
        Z1 = [Z1 data.wall(j).p4(3)];
        Z2 = [Z2 data.wall(j).p1(3)];    
    end

        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'color','r','MarkerSize',30);
        hold on


    X1 = [];
    X2 = [];
    Y1 = [];
    Y2 = [];
    Z1 = [];
    Z2 = [];

    for j=data.finPrimeraPlanta+1:1:data.finSegundaPlanta 
        % Lnea 1 (abajo)
        X1 = [X1 data.wall(j).p1(1)];
        X2 = [X2 data.wall(j).p2(1)];
        Y1 = [Y1 data.wall(j).p1(2)];
        Y2 = [Y2 data.wall(j).p2(2)];
        Z1 = [Z1 data.wall(j).p1(3)];
        Z2 = [Z2 data.wall(j).p2(3)];

        % Lnea 1 (haca arriba)
        X1 = [X1 data.wall(j).p2(1)];
        X2 = [X2 data.wall(j).p3(1)];
        Y1 = [Y1 data.wall(j).p2(2)];
        Y2 = [Y2 data.wall(j).p3(2)];
        Z1 = [Z1 data.wall(j).p2(3)];
        Z2 = [Z2 data.wall(j).p3(3)];

        % Lnea 1 (arriba)
        X1 = [X1 data.wall(j).p3(1)];
        X2 = [X2 data.wall(j).p4(1)];
        Y1 = [Y1 data.wall(j).p3(2)];
        Y2 = [Y2 data.wall(j).p4(2)];
        Z1 = [Z1 data.wall(j).p3(3)];
        Z2 = [Z2 data.wall(j).p4(3)];


        % Lnea 1 (haca abajo)
        X1 = [X1 data.wall(j).p4(1)];
        X2 = [X2 data.wall(j).p1(1)];
        Y1 = [Y1 data.wall(j).p4(2)];
        Y2 = [Y2 data.wall(j).p1(2)];
        Z1 = [Z1 data.wall(j).p4(3)];
        Z2 = [Z2 data.wall(j).p1(3)];    
    end

        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'color','g','MarkerSize',30);
        hold on
        
      X1 = [];
    X2 = [];
    Y1 = [];
    Y2 = [];
    Z1 = [];
    Z2 = [];

    for j=data.finSegundaPlanta +1:1:data.fincosas 
        % Lnea 1 (abajo)
        X1 = [X1 data.wall(j).p1(1)];
        X2 = [X2 data.wall(j).p2(1)];
        Y1 = [Y1 data.wall(j).p1(2)];
        Y2 = [Y2 data.wall(j).p2(2)];
        Z1 = [Z1 data.wall(j).p1(3)];
        Z2 = [Z2 data.wall(j).p2(3)];

        % Lnea 1 (haca arriba)
        X1 = [X1 data.wall(j).p2(1)];
        X2 = [X2 data.wall(j).p3(1)];
        Y1 = [Y1 data.wall(j).p2(2)];
        Y2 = [Y2 data.wall(j).p3(2)];
        Z1 = [Z1 data.wall(j).p2(3)];
        Z2 = [Z2 data.wall(j).p3(3)];

        % Lnea 1 (arriba)
        X1 = [X1 data.wall(j).p3(1)];
        X2 = [X2 data.wall(j).p4(1)];
        Y1 = [Y1 data.wall(j).p3(2)];
        Y2 = [Y2 data.wall(j).p4(2)];
        Z1 = [Z1 data.wall(j).p3(3)];
        Z2 = [Z2 data.wall(j).p4(3)];


        % Lnea 1 (haca abajo)
        X1 = [X1 data.wall(j).p4(1)];
        X2 = [X2 data.wall(j).p1(1)];
        Y1 = [Y1 data.wall(j).p4(2)];
        Y2 = [Y2 data.wall(j).p1(2)];
        Z1 = [Z1 data.wall(j).p4(3)];
        Z2 = [Z2 data.wall(j).p1(3)];    
    end

    plot3([X1; X2], [Y1; Y2], [Z1; Z2],'color','k','MarkerSize',30);
    hold on
    
    hold on
    plot3(data.pE1(:,1),data.pE1(:,2),data.pE1(:,3),'color','K','MarkerSize',10);
    hold off
  
elseif(planta == 0)
    
    % Pintdata.aMos los muros esteriores
    X1 = [];
    X2 = [];
    Y1 = [];
    Y2 = [];
    Z1 = [];
    Z2 = [];


    for j=1:1:data.finPlantaBaja 
        % Lnea 1 (abajo)
        X1 = [X1 data.wall(j).p1(1)];
        X2 = [X2 data.wall(j).p2(1)];
        Y1 = [Y1 data.wall(j).p1(2)];
        Y2 = [Y2 data.wall(j).p2(2)];
        Z1 = [Z1 data.wall(j).p1(3)];
        Z2 = [Z2 data.wall(j).p2(3)];

        % Lnea 1 (haca arriba)
        X1 = [X1 data.wall(j).p2(1)];
        X2 = [X2 data.wall(j).p3(1)];
        Y1 = [Y1 data.wall(j).p2(2)];
        Y2 = [Y2 data.wall(j).p3(2)];
        Z1 = [Z1 data.wall(j).p2(3)];
        Z2 = [Z2 data.wall(j).p3(3)];

        % Lnea 1 (arriba)
        X1 = [X1 data.wall(j).p3(1)];
        X2 = [X2 data.wall(j).p4(1)];
        Y1 = [Y1 data.wall(j).p3(2)];
        Y2 = [Y2 data.wall(j).p4(2)];
        Z1 = [Z1 data.wall(j).p3(3)];
        Z2 = [Z2 data.wall(j).p4(3)];


        % Lnea 1 (haca abajo)
        X1 = [X1 data.wall(j).p4(1)];
        X2 = [X2 data.wall(j).p1(1)];
        Y1 = [Y1 data.wall(j).p4(2)];
        Y2 = [Y2 data.wall(j).p1(2)];
        Z1 = [Z1 data.wall(j).p4(3)];
        Z2 = [Z2 data.wall(j).p1(3)];    
    end

    % Muros del sistema
        % Para ver si est todo correcto
        
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'color','b','MarkerSize',10);
        hold on
        
        
    elseif(planta == 0)
    
    % Pintdata.aMos los muros esteriores
    X1 = [];
    X2 = [];
    Y1 = [];
    Y2 = [];
    Z1 = [];
    Z2 = [];


    for j=1:finPlantaBaja+1:data.finPrimeraPlanta 
        % Lnea 1 (abajo)
        X1 = [X1 data.wall(j).p1(1)];
        X2 = [X2 data.wall(j).p2(1)];
        Y1 = [Y1 data.wall(j).p1(2)];
        Y2 = [Y2 data.wall(j).p2(2)];
        Z1 = [Z1 data.wall(j).p1(3)];
        Z2 = [Z2 data.wall(j).p2(3)];

        % Lnea 1 (haca arriba)
        X1 = [X1 data.wall(j).p2(1)];
        X2 = [X2 data.wall(j).p3(1)];
        Y1 = [Y1 data.wall(j).p2(2)];
        Y2 = [Y2 data.wall(j).p3(2)];
        Z1 = [Z1 data.wall(j).p2(3)];
        Z2 = [Z2 data.wall(j).p3(3)];

        % Lnea 1 (arriba)
        X1 = [X1 data.wall(j).p3(1)];
        X2 = [X2 data.wall(j).p4(1)];
        Y1 = [Y1 data.wall(j).p3(2)];
        Y2 = [Y2 data.wall(j).p4(2)];
        Z1 = [Z1 data.wall(j).p3(3)];
        Z2 = [Z2 data.wall(j).p4(3)];


        % Lnea 1 (haca abajo)
        X1 = [X1 data.wall(j).p4(1)];
        X2 = [X2 data.wall(j).p1(1)];
        Y1 = [Y1 data.wall(j).p4(2)];
        Y2 = [Y2 data.wall(j).p1(2)];
        Z1 = [Z1 data.wall(j).p4(3)];
        Z2 = [Z2 data.wall(j).p1(3)];    
    end

    % Muros del sistema
        % Para ver si est todo correcto
        
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'color','b','MarkerSize',10);
        hold on
        
    % Pintdata.aMos los muros esteriores
    X1 = [];
    X2 = [];
    Y1 = [];
    Y2 = [];
    Z1 = [];
    Z2 = [];


    for j=1:1:data.finPlantaBaja 
        % Lnea 1 (abajo)
        X1 = [X1 data.wall(j).p1(1)];
        X2 = [X2 data.wall(j).p2(1)];
        Y1 = [Y1 data.wall(j).p1(2)];
        Y2 = [Y2 data.wall(j).p2(2)];
        Z1 = [Z1 data.wall(j).p1(3)];
        Z2 = [Z2 data.wall(j).p2(3)];

        % Lnea 1 (haca arriba)
        X1 = [X1 data.wall(j).p2(1)];
        X2 = [X2 data.wall(j).p3(1)];
        Y1 = [Y1 data.wall(j).p2(2)];
        Y2 = [Y2 data.wall(j).p3(2)];
        Z1 = [Z1 data.wall(j).p2(3)];
        Z2 = [Z2 data.wall(j).p3(3)];

        % Lnea 1 (arriba)
        X1 = [X1 data.wall(j).p3(1)];
        X2 = [X2 data.wall(j).p4(1)];
        Y1 = [Y1 data.wall(j).p3(2)];
        Y2 = [Y2 data.wall(j).p4(2)];
        Z1 = [Z1 data.wall(j).p3(3)];
        Z2 = [Z2 data.wall(j).p4(3)];


        % Lnea 1 (haca abajo)
        X1 = [X1 data.wall(j).p4(1)];
        X2 = [X2 data.wall(j).p1(1)];
        Y1 = [Y1 data.wall(j).p4(2)];
        Y2 = [Y2 data.wall(j).p1(2)];
        Z1 = [Z1 data.wall(j).p4(3)];
        Z2 = [Z2 data.wall(j).p1(3)];    
    end

    % Muros del sistema
        % Para ver si est todo correcto
        
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'color','b','MarkerSize',10);
        hold on
        
        
    elseif(planta == 0)
    
    % Pintdata.aMos los muros esteriores
    X1 = [];
    X2 = [];
    Y1 = [];
    Y2 = [];
    Z1 = [];
    Z2 = [];

    for j=1:1:data.finPlantaBaja 
        % Lnea 1 (abajo)
        X1 = [X1 data.wall(j).p1(1)];
        X2 = [X2 data.wall(j).p2(1)];
        Y1 = [Y1 data.wall(j).p1(2)];
        Y2 = [Y2 data.wall(j).p2(2)];
        Z1 = [Z1 data.wall(j).p1(3)];
        Z2 = [Z2 data.wall(j).p2(3)];

        % Lnea 1 (haca arriba)
        X1 = [X1 data.wall(j).p2(1)];
        X2 = [X2 data.wall(j).p3(1)];
        Y1 = [Y1 data.wall(j).p2(2)];
        Y2 = [Y2 data.wall(j).p3(2)];
        Z1 = [Z1 data.wall(j).p2(3)];
        Z2 = [Z2 data.wall(j).p3(3)];

        % Lnea 1 (arriba)
        X1 = [X1 data.wall(j).p3(1)];
        X2 = [X2 data.wall(j).p4(1)];
        Y1 = [Y1 data.wall(j).p3(2)];
        Y2 = [Y2 data.wall(j).p4(2)];
        Z1 = [Z1 data.wall(j).p3(3)];
        Z2 = [Z2 data.wall(j).p4(3)];


        % Lnea 1 (haca abajo)
        X1 = [X1 data.wall(j).p4(1)];
        X2 = [X2 data.wall(j).p1(1)];
        Y1 = [Y1 data.wall(j).p4(2)];
        Y2 = [Y2 data.wall(j).p1(2)];
        Z1 = [Z1 data.wall(j).p4(3)];
        Z2 = [Z2 data.wall(j).p1(3)];    
    end

    % Muros del sistema
        % Para ver si est todo correcto
        
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'color','b','MarkerSize',10);
        hold on
end       



end       


